//**************************************************************************************
//**************************************************************************************
//****																				****
//****								  LCD.H											****
//****																				****
//****			LCD.h Routinen zur Darstellung der Messwerte etc.					****
//****			fr Digitalanzeige mit S65 Display (Magnetmesssystem)				****
//****			copyrigth (c) 2008 by Dipl. Ing. Steffen Taubmann					****
//****																				****
//****			Kontakt: steffenta@gmx.de											****
//****																				****
//**************************************************************************************
//****		 																		****
//****	Fr private Anwender gilt:													****
//****		 																		****
//****		Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen ****
//****		der GNU General Public License, wie von der Free Software Foundation 	****
//****		verffentlicht, weitergeben und/oder modifizieren, entweder gem 		****
//****		Version 3 der Lizenz oder (nach Ihrer Option) jeder spteren Version.	****
//****																				****
//****		Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es	****
//****		Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne	****
//****		die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN	****
//****		BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.	****
//****		 																		****
//****		Sie sollten ein Exemplar der GNU General Public License zusammen mit	****
//****		diesem Programm erhalten haben. 										****
//****		Falls nicht, siehe <http://www.gnu.org/licenses/>.						****
//****																				****
//****	Die kommerzielle Verwendung des Quellcodes bedarf generell der Genehmigung	****
//****	des Autors. Mit kommerzieller Verwendung ist der Verkauf von auf diesem		****
//****	Code basierenden Systemen zu verstehen. Der Einsatz des Systems in einem	****
//****	kommerziellen Umfeld ist davon nicht betroffen.								****
//****																				****
//**************************************************************************************
//**************************************************************************************


//***********************************************************************
//****																
//****	Bildschirm initialisieren
//****							
//***********************************************************************

void Init_Screen()
{ LCD_Rect(0,0,175,15,cl_Red);
  LCD_Rect(0,16,175,121,cl_Blue);
  LCD_Rect(0,122,175,131,cl_Yellow);
}

//***********************************************************************
//****																
//****	Bezeichnungen der Buttons darstellen			
//****															
//***********************************************************************
void ButtonCaption(int Button)
{ FontColor=LCD_BTFTColor; BackGroundColor=LCD_BTBGColor;
  switch (Button)
  { case 1: LCDPutString(20,173,LCDStr,ft_Small,ta_center); break;
	case 2: LCDPutString(66,173,LCDStr,ft_Small,ta_center); break;
	case 3: LCDPutString(112,173,LCDStr,ft_Small,ta_center); break;
	default: break;
  }
}

//***********************************************************************
//****																
//****	Bezeichnungen der Buttons lschen					
//****																
//***********************************************************************
void CLRButtonCaption()
{ BackGroundColor=LCD_BTBGColor;
  STRCpy(LCDSTR,"      ");
  LCDPutString(20,173,LCDStr,ft_Small,ta_center);
  LCDPutString(66,173,LCDStr,ft_Small,ta_center);
  LCDPutString(112,173,LCDStr,ft_Small,ta_center);
}


//***********************************************************************
//****														
//****	Darstellung der einzelnen Bildschirme mit Prozessdaten
//****															
//***********************************************************************

void ShowScreen(s)
{
  switch(s)
  { case 0:
		BackGroundColor=LCD_BGColor;
  		LCDCLS();					
		// Buttons
		FontColor=LCD_BTBGColor;
  		STRCpy(LCDSTR,"\x01\x02\x02\x02\x03");
		LCDPutString(0,175,LCDSTR,FT_Large, ta_left);
		LCDPutString(66,175,LCDSTR,FT_Large, ta_Center);
		LCDPutString(131,175,LCDSTR,FT_Large, ta_Right);
		sprintf(LCDSTR,"X=%Ld",XOffset); ButtonCaption(1);
  		sprintf(LCDSTR,"Y=%Ld",YOffset); ButtonCaption(2);
  		sprintf(LCDSTR,"Z=%Ld",ZOffset); ButtonCaption(3);

		// berschrift
  		FontColor=LCD_BTFTColor; BackGroundColor=LCD_BTBGColor;
  		LCD_Rect(0,0,131,10,CL_Blue);
  		STRCpy(LCDSTR,"Messwerte");
  		LCDPutString(66,9,LCDSTR,FT_Small, ta_Center);

		// Messwerte
	  	FontColor=LCD_FTColor; BackGroundColor=LCD_BGColor;
/*	  	STRCpy(LCDSTR,"X:    0,00mm");
	  	LCDPutString(20,42,LCDSTR,FT_Large, ta_Left);
	  	STRCpy(LCDSTR,"Y:    0,00mm");
	  	LCDPutString(20,78,LCDSTR,FT_Large, ta_Left);
	  	STRCpy(LCDSTR,"Z:    0,00mm");
	  	LCDPutString(20,114,LCDSTR,FT_Large, ta_Left);
*/
	  	STRCpy(LCDSTR,"n:    0U/min");
	  	LCDPutString(20,150,LCDSTR,FT_Large, ta_Left);
	  break;
	case 1:
		BackGroundColor=LCD_BGColor;
  		LCDCLS();					
		// Buttons
		FontColor=LCD_BTBGColor;
  		STRCpy(LCDSTR,"\x01\x02\x02\x02\x03");
		LCDPutString(0,175,LCDSTR,FT_Large, ta_left);
		LCDPutString(66,175,LCDSTR,FT_Large, ta_Center);
		LCDPutString(131,175,LCDSTR,FT_Large, ta_Right);

		// berschrift
  		FontColor=LCD_BTFTColor; BackGroundColor=LCD_BTBGColor;
  		LCD_Rect(0,0,131,10,CL_Blue);
  		STRCpy(LCDSTR,"Parametrierung");
  		LCDPutString(66,9,LCDSTR,FT_Small, ta_Center);

		// Parametrierungswerte
		FontColor=LCD_FTColor; BackGroundColor=LCD_BGColor;
		if(XOffset>=0)
		 sprintf(LCDSTR,"Offset X: %3Ldmm",XOffset);
		else
		 sprintf(LCDSTR,"Offset X:%3Ldmm",XOffset);
		LCDPutString(8,48,LCDSTR,FT_Large, ta_Left);
		if(YOffset>=0)
		  sprintf(LCDSTR,"Offset Y: %3Ldmm",YOffset);
		else
		  sprintf(LCDSTR,"Offset Y:%3Ldmm",YOffset);
		LCDPutString(8,68,LCDSTR,FT_Large, ta_Left);
		if(YOffset>=0)
		  sprintf(LCDSTR,"Offset Z: %3Ldmm",ZOffset);
		else
		  sprintf(LCDSTR,"Offset Z:%3Ldmm",ZOffset);
		LCDPutString(8,88,LCDSTR,FT_Large, ta_Left);
		STRCpy(LCDSTR,"RS485 Adr:    0");
		LCDPutString(8,108,LCDSTR,FT_Large, ta_left);
		if(MaschType==0)
		  STRCpy(LCDSTR,"Fr\x84smaschine");
		else
		  STRCpy(LCDSTR,"Drehmaschine");
		LCDPutString(66,128,LCDSTR,FT_Large, ta_Center);
		STRCpy(LCDSTR,"Beenden");
		LCDPutString(66,148,LCDSTR,FT_Large, ta_Center);
		FontColor=CL_Red;
 		X_Pos=0; Y_Pos=45; LCDPutChar(0x1A,FT_Small);		// aktiven Punkt markieren
 	  break;

	default: break;
  }

}

//***********************************************************************
//****														
//****	Messwerte auslesen und darstellen
//****															
//***********************************************************************

void GetAndShowValue(int Adr)
{ int32 Pos;
  int x; 
  int AS5311Flags;
	#bit Flag_SDOK=AS5311Flags.5				// serieller Datenstrom vom AS5311 OK
	#bit Flag_OCF=AS5311Flags.4					// Offset Compensation Finished
	#bit Flag_COF=AS5311Flags.3					// Cordic Overflow
	#bit Flag_LIN=AS5311Flags.2					// Linearity Alarm
	#Bit Flag_MagInc=AS5311Flags.1
	#bit Flag_MagDec=AS5311Flags.0
  char ValueStr[12];

  // X, Y, Z Sensoren? (ADR=0..2)
  if (Adr<=2)
  {	x=MMS_GetABSPosition(Adr, &Pos, &AS5311Flags);
	if((x==0) && Flag_SDOK && Flag_OCF && !Flag_COF)		// Daten angekommen und verwertbar?
	{ if (Adr==0) 
	  { Pos+=XSOffset;										// Offset dazuaddiern
		ValueToMM(ValueStr,Pos);							// in mm umrechnen
		STRCpy(LCDSTR,"X: "); StrCat(LcdStr,ValueStr);
      } 
	  if (Adr==1) 
	  { if(MaschType==1) Pos*=2;							// Drehmaschine --> Wert verdoppeln
		Pos+=YSOffset;										// Offset dazuaddiern
		ValueToMM(ValueStr,Pos);							// in mm umrechnen
		STRCpy(LCDSTR,"Y: "); StrCat(LcdStr,ValueStr);
      } 
	  if (Adr==2) 
	  { Pos+=ZSOffset;										// Offset dazuaddiern
		ValueToMM(ValueStr,Pos);							// in mm umrechnen
		STRCpy(LCDSTR,"Z: "); StrCat(LcdStr,ValueStr);
      } 

	  FontColor=LCD_FTColor; BackGroundColor=LCD_BGColor;
	  LCDPutString(15,42+36*Adr,LCDSTR,FT_Large, ta_Left);	// Wert anzeigen
	  // aus Flags Bereich bilden
	  X_Pos=5; Y_Pos=42+36*Adr;
	  if(Flag_MagInc && Flag_MagDec && Flag_LIN)			// roter Bereich
	    FontColor=Cl_red; 
	  else
 	    if(Flag_MagInc && Flag_MagDec)						// gelber Bereich
		  FontColor=Cl_Yellow;
		else
		  FontColor=Cl_Green;								// grner Bereich
	  LCDPutChar(4,FT_Large);								// Bereich signalisieren (Punkt vor Bezeichnung)
	} // if((x==0) && Flag_SDOK && Flag_OCF && !Flag_COF)
	else
	{
	 #ifdef DezimalDigits2
	  if (Adr==0) STRCpy(LCDSTR,"X:   ???,??mm"); 
	  if (Adr==1) STRCpy(LCDSTR,"Y:   ???,??mm ");
	  if (Adr==2) STRCpy(LCDSTR,"Z:   ???,??mm");
	 #else
	  if (Adr==0) STRCpy(LCDSTR,"X:   ???,???mm"); 
	  if (Adr==1) STRCpy(LCDSTR,"Y:   ???,???mm ");
	  if (Adr==2) STRCpy(LCDSTR,"Z:   ???,???mm");
	 #endif
	  FontColor=LCD_FTColor;
	  LCDPutString(15,42+36*Adr,LCDSTR,FT_Large, ta_Left);	// Wert anzeigen
	}

  } // if (Adr<=2)
}

//  ********************************************************************
//	****														
//	****	nderung der Parameter
//	****										
//  ********************************************************************
void ChangeParams()
{ int RSAdr=0;

  signed int AktParam=0;						// aktuell zu ndernder Parameter
  short _ParamChange=false;				// true --> Wertnderung / false --> Parameternderung
  short _EndParam=false;

  int Taste;

  EncValue=0;

  while(!_EndParam)
  {	if (_TastAbfrage)
	{ Taste=GetTaste();
	  _TastAbfrage=false;
	}

	// Encoder Taste?
	if(Taste==1)
	{ _ParamChange=(!_ParamChange);					// Umschaltung Wert/Parameter
	  while(GetTaste()!=0) Restart_wdt();
	  EncValue=0;
	  if(_ParamChange)
	  { FontColor=CL_green; BackGroundColor=LCD_BGColor;
		X_Pos=0; Y_Pos=Aktparam*20+45; LCDPutChar(0x10,FT_Small);		// Modus anzeigen
		if(AktParam==3)													// Adresse setzen?
  		{ STRCpy(LCDSTR,"SetAdr"); ButtonCaption(3);}					// ja Button 3 anzeigen
	  }
	  else
	  { FontColor=CL_Red; BackGroundColor=LCD_BGColor;
		X_Pos=0; Y_Pos=Aktparam*20+45; LCDPutChar(0x1A,FT_Small);		// Modus anzeigen
		if(AktParam==3) CLRButtonCaption();
	  }
	  if(AktParam==5) _EndParam=true;
	}

	// Taste 3?
	If((Taste==4)&&_ParamChange)										// nderungsmodus und Taste3?
	{ while(GetTaste()!=0) Restart_wdt();
	  BackGroundColor=LCD_BGColor;
	  if(MMS_SetSysAdr(RSAdr)==0)
	  { FontColor=Cl_Green;
		STRCpy(LcdStr,"   OK"); LCDPutString(88,108,LCDSTR,FT_Large, ta_Left);
		Delay_ms(2000);													// 2s Pause
	  }
	  else
	  { FontColor=Cl_Red;
		STRCpy(LcdStr,"ERROR"); LCDPutString(88,108,LCDSTR,FT_Large, ta_Left);
		Delay_ms(2000);													// 2s Pause
	  }
	FontColor=LCD_FTColor;
	sprintf(LCDStr,"  %3U",RSAdr);									// Wert wieder anzeigen
	LCDPutString(88,108,LCDSTR,FT_Large, ta_Left);
	}

	Taste=0;
	 
	if(_ParamChange)
	 { if(EncValue!=0)
	   { FontColor=LCD_FTColor; BackGroundColor=LCD_BGColor;
		 switch(AktParam)
		 { case 0:	
			XOffset+=EncValue;			// X-Offset
			if(XOffset<-999) XOffset=-999;
			if(XOffset>999) XOffset=999;
			if(XOffset>=0) sprintf(LCDStr," %3Ldmm",XOffset); else sprintf(LCDStr,"%3Ldmm",XOffset);
			LCDPutString(80,48,LCDSTR,FT_Large, ta_Left);
		  break;
		  case 1:
			YOffset+=EncValue;			// Y-Offset
			if(YOffset<-999) YOffset=-999;
			if(YOffset>999) YOffset=999;
			if(YOffset>=0) sprintf(LCDStr," %3Ldmm",YOffset); else sprintf(LCDStr,"%3Ldmm",YOffset);
			LCDPutString(80,68,LCDSTR,FT_Large, ta_Left);
		  break;
		  case 2:
			ZOffset+=EncValue;			// Y-Offset
			if(ZOffset<-999) ZOffset=-999;
			if(ZOffset>999) ZOffset=999;
			if(ZOffset>=0) sprintf(LCDStr," %3Ldmm",ZOffset); else sprintf(LCDStr,"%3Ldmm",ZOffset);
			LCDPutString(80,88,LCDSTR,FT_Large, ta_Left);
		  break;
		  case 3:
			RSAdr+=EncValue;
			sprintf(LCDStr,"%3U",RSAdr);
			LCDPutString(104,108,LCDSTR,FT_Large, ta_Left);
		  break;
		  case 4:
			if(MaschType==0)
			{ MaschType=1;
	  		  STRCpy(LCDSTR,"Drehmaschine");
			}
			 else
			{ MaschType=0;
			  STRCpy(LCDSTR,"Fr\x84smaschine");
			}
			LCDPutString(66,128,LCDSTR,FT_Large, ta_Center);
		  break;
		  default: break;
	    }
		EncValue=0;
	  }// if(EncValue!=0)
	} //if(_ParamChange)
	else
	{ if(EncValue!=0)
	  {
		FontColor=CL_Red; BackGroundColor=LCD_BGColor;
		X_Pos=0; Y_Pos=Aktparam*20+45; LCDPutChar(0x20,FT_Small);		// alte Markierung lschen
		AktParam=AktParam+EncValue;
		if(Aktparam>5) Aktparam=0;
		if(Aktparam<0) Aktparam=5;
		EncValue=0;
 		X_Pos=0; Y_Pos=Aktparam*20+45; LCDPutChar(0x1A,FT_Small);		// aktiven Punkt markieren
	  } 
	}
  }//while(!_EndParam)

  StoreParameter();

  // wieder in Anzeigemodus wechseln
  SysMode=0;
  ShowScreen(0);
  While(GetTaste()!=0) Restart_wdt();	// warten, bis Taste wieder losgelassen
}
